// priority: 100
onEvent('recipes', (event) => {
    //Throw in mana pool recipes, commented in case we need it
    // const manaInfusion = (input, output, manaCost) => {
    //     event.custom({
    //         type: 'botania:mana_infusion',
    //         input: {
    //             item: input
    //         },
    //         output: {
    //             item: output
    //         },
    //         mana: cost
    //     });
    // }
    //manaInfusion('minecraft:quartz_block', 'botania:mana_quartz', 1000)

    const simpleElvenTrade = (input, output) => {
        event.custom({
            type: "botania:elven_trade",
            ingredients: [
                {
                    item: input
                }
            ],
            output: [
                {
                    item: output
                }
            ]
        });
    }
    simpleElvenTrade('mekanism:quantum_entangloporter', 'kubejsadditions:tesseract_frame');

    const manaInfusionCatalyst = (input, output, manaCost, catalyst, recipeId) => {
        if (input.startsWith('#')) {
            input = input.substring(1);
            event.custom({
                type: "botania:mana_infusion",
                input: {
                    "tag": input
                },
                output: {
                    "item": output
                },
                mana: manaCost,
                catalyst: {
                    type: "block",
                    block: catalyst
                }
            }).id(recipeId);
        } else {
            event.custom({
                type: "botania:mana_infusion",
                input: {
                    "item": input
                },
                output: {
                    "item": output
                },
                mana: manaCost,
                catalyst: {
                    type: "block",
                    block: catalyst
                }
            }).id(recipeId);
        }
    }
    manaInfusionCatalyst('#forge:slimeballs', 'minecraft:cactus', 1200, 'botania:alchemy_catalyst', 'botania:mana_infusion/slime_to_cactus')

    //Allow crafting of the Overgrowth seed in 1.2.0+ since it isn't added to dungeons yet
    event.custom({
        "type": "ars_nouveau:enchanting_apparatus",
        "reagent": [
            {
                "item": 'mysticalagriculture:nature_seeds'
            }
        ],
        "pedestalItems": [
            {
                "item": {
                    "item": 'quark:moss_paste'
                }
            },
            {
                "item": {
                    "item": 'quark:moss_paste'
                }
            },
            {
                "item": {
                    "item": 'quark:moss_paste'
                }
            },
            {
                "item": {
                    "item": 'quark:moss_paste'
                }
            },
            {
                "item": {
                    "item": 'quark:moss_paste'
                }
            },
            {
                "item": {
                    "item": 'quark:moss_paste'
                }
            },
            {
                "item": {
                    "item": 'quark:moss_paste'
                }
            },
            {
                "item": {
                    "item": 'quark:moss_paste'
                }
            }
        ],
        "output": {
            "item": 'botania:overgrowth_seed'
        },
        "sourceCost": 1000
    })

    //type: orechid
    //input: minecraft:stone
    //output: minecraft:diamond_ore
    //weight: 20
    const oreChid = (type, input, output, weight) => {
        event.custom({
            type: 'botania:' + type,
            input: input,
            output: {
                type: 'block',
                block: output
            },
            weight: weight
        });
    }

    //Overworld oreChid
    //If we take startup_scripts/global.js as reference and the list of seeds, there are 4 tiers of ore.
    //Upon testing, we'll balance them out like so for stone:
    const stone = 'minecraft:stone'
    //Tier 2: 70
    oreChid('orechid', stone, 'minecraft:coal_ore', 70)
    oreChid('orechid', stone, 'immersiveengineering:ore_aluminum', 70)
    oreChid('orechid', stone, 'thermal:sulfur_ore', 70)
    oreChid('orechid', stone, 'thermal:niter_ore', 70)
    oreChid('orechid', stone, 'thermal:apatite_ore', 70)
    //Tier 3: 70
    oreChid('orechid', stone, 'minecraft:copper_ore', 70)
    oreChid('orechid', stone, 'minecraft:iron_ore', 70)
    oreChid('orechid', stone, 'minecraft:redstone_ore', 70)
    oreChid('orechid', stone, 'thermal:lead_ore', 70)
    oreChid('orechid', stone, 'thermal:silver_ore', 70)
    oreChid('orechid', stone, 'create:zinc_ore', 70)
    oreChid('orechid', stone, 'mysticalagriculture:prosperity_ore', 70)
    oreChid('orechid', stone, 'ae2:quartz_ore', 70)
    oreChid('orechid', stone, 'malum:soulstone_ore', 70)
    oreChid('orechid', stone, 'thermal:tin_ore', 70)
    oreChid('orechid', stone, 'thermal:cinnabar_ore', 70)
    oreChid('orechid', stone, 'hearthstones:aquamarine_ore', 70)
    //Tier 4: 35
    oreChid('orechid', stone, 'minecraft:lapis_ore', 35)
    oreChid('orechid', stone, 'minecraft:gold_ore', 35)
    oreChid('orechid', stone, 'mekanism:osmium_ore', 35)
    oreChid('orechid', stone, 'thermal:nickel_ore', 35)
    oreChid('orechid', stone, 'mekanism:uranium_ore', 35)
    oreChid('orechid', stone, 'malum:brilliant_stone', 35)
    oreChid('orechid', stone, 'mekanism:fluorite_ore', 35)
    oreChid('orechid', stone, 'thermal:sapphire_ore', 35)
    oreChid('orechid', stone, 'thermal:ruby_ore', 35)
    //Tier 5: 20
    oreChid('orechid', stone, 'minecraft:diamond_ore', 20)
    oreChid('orechid', stone, 'minecraft:emerald_ore', 20)
    oreChid('orechid', stone, 'rftoolsbase:dimensionalshard_overworld', 20)

    //For minecraft:deepslate, we want to allow players to have a bit more rich ores. Because it'll be harder to
    //renew deepslate than to renew stone (which is super easy from cobble)
    //Here will be the weights for deepslate:
    const deepslate = 'minecraft:deepslate'
    //Tier 2: 50
    oreChid('orechid', deepslate, 'minecraft:deepslate_coal_ore', 50)
    oreChid('orechid', deepslate, 'immersiveengineering:deepslate_ore_aluminum', 50)
    oreChid('orechid', deepslate, 'thermal:deepslate_sulfur_ore', 50)
    oreChid('orechid', deepslate, 'thermal:deepslate_niter_ore', 50)
    oreChid('orechid', deepslate, 'thermal:deepslate_apatite_ore', 50)
    //Tier 3: 50
    oreChid('orechid', deepslate, 'minecraft:deepslate_copper_ore', 50)
    oreChid('orechid', deepslate, 'minecraft:deepslate_iron_ore', 50)
    oreChid('orechid', deepslate, 'minecraft:deepslate_redstone_ore', 50)
    oreChid('orechid', deepslate, 'thermal:deepslate_lead_ore', 50)
    oreChid('orechid', deepslate, 'thermal:deepslate_silver_ore', 50)
    oreChid('orechid', deepslate, 'create:deepslate_zinc_ore', 50)
    oreChid('orechid', deepslate, 'mysticalagriculture:deepslate_prosperity_ore', 50)
    oreChid('orechid', deepslate, 'ae2:deepslate_quartz_ore', 50)
    oreChid('orechid', deepslate, 'malum:deepslate_soulstone_ore', 50)
    oreChid('orechid', deepslate, 'thermal:deepslate_tin_ore', 50)
    oreChid('orechid', deepslate, 'thermal:deepslate_cinnabar_ore', 50)
    oreChid('orechid', deepslate, 'hearthstones:deepslate_aquamarine_ore', 50)
    //Tier 4: 40
    oreChid('orechid', deepslate, 'minecraft:deepslate_lapis_ore', 40)
    oreChid('orechid', deepslate, 'minecraft:deepslate_gold_ore', 40)
    oreChid('orechid', deepslate, 'mekanism:deepslate_osmium_ore', 40)
    oreChid('orechid', deepslate, 'thermal:deepslate_nickel_ore', 40)
    oreChid('orechid', deepslate, 'mekanism:deepslate_uranium_ore', 40)
    oreChid('orechid', deepslate, 'mekanism:deepslate_fluorite_ore', 40)
    oreChid('orechid', deepslate, 'malum:brilliant_deepslate', 40)
    oreChid('orechid', deepslate, 'thermal:deepslate_sapphire_ore', 40)
    oreChid('orechid', deepslate, 'thermal:deepslate_ruby_ore', 40)
    //Tier 5: 30
    oreChid('orechid', deepslate, 'minecraft:deepslate_diamond_ore', 30)
    oreChid('orechid', deepslate, 'minecraft:deepslate_emerald_ore', 30)

    //Nether oreChid
    const netherrack = 'minecraft:netherrack'
    //For Nether we use the same weights, this will encourage people to use the mod. "Easy" debris?
    //Tier 2: 70
    oreChid('orechid_ignem', netherrack, 'minecraft:nether_quartz_ore', 70)
    oreChid('orechid_ignem', netherrack, 'malum:blazing_quartz_ore', 70)
    //Tier 3: 70
    oreChid('orechid_ignem', netherrack, 'minecraft:nether_gold_ore', 70)
    oreChid('orechid_ignem', netherrack, 'elementaryores:ore_iron_nether', 70)
    //Tier 4: 35
    oreChid('orechid_ignem', netherrack, 'elementaryores:ore_lapis_nether', 35)
    oreChid('orechid_ignem', netherrack, 'elementaryores:ore_ghast_nether', 35)
    //Tier 5: 20
    oreChid('orechid_ignem', netherrack, 'tconstruct:cobalt_ore', 20)
    oreChid('orechid_ignem', netherrack, 'minecraft:ancient_debris', 20)

    //We can be cool and use soulstone too, for an increased ancient debris chance (we'll have a cobble gen that gives cobbled soulstone)
    //The above gives roughly 8% chance of ancient debris, so let's give it about 5 more percent if using soulstone
    const soulstone = 'mysticalagriculture:soulstone'
    oreChid('orechid_ignem', soulstone, 'mysticalagriculture:soulium_ore', 7)
    oreChid('orechid_ignem', soulstone, 'minecraft:ancient_debris', 1)

    //Nether oreChid in the End
    const end_stone = 'minecraft:end_stone'
    //Tier: 3
    oreChid('orechid_ignem', end_stone, 'rftoolsbase:dimensionalshard_end', 50)
    oreChid('orechid_ignem', end_stone, 'elementaryores:ore_redstone_end', 50)
    //Tier: 4
    oreChid('orechid_ignem', end_stone, 'elementaryores:ore_ender_end', 35)
    //Tier: 5
    oreChid('orechid_ignem', end_stone, 'elementaryores:ore_diamond_end', 20)

    //Using Otherstone for a guaranteed Iesnium ore
    //Promotes getting into both mods
    const otherstone = 'occultism:otherstone'
    oreChid('orechid_ignem', otherstone, 'occultism:iesnium_ore', 1)
});

